
This rule verifies that single-line comments are not located at the ends of lines of code. The main idea behind this rule is that in order to be really readable, trailing comments would have to be properly written and formatted (correct alignment, no interference with the visual structure of the code, not too long to be visible) but most often, automatic code formatters would not handle this correctly: the code would end up less readable. Comments are far better placed on the previous empty line of code, where they will always be visible and properly formatted.

## Noncompliant Code Example

With the default comment pattern `^'\s*\S+\s*$`, which ignores single word comments:


    Module Module1
      Sub Main()
        Console.WriteLine("Hello, world!") ' Noncompliant - My first program!
        Console.WriteLine("Hello, world!") ' CompliantOneWord
      End Sub
    End Module


## Compliant Solution


    Module Module1
      Sub Main()
        ' Compliant - My first program!
        Console.WriteLine("Hello, world!")
        Console.WriteLine("Hello, world!") ' CompliantOneWord
      End Sub
    End Module

