
Consistently using the `&` operator for string concatenation make the developer intentions clear.

`&`, unlike `+`, will convert its operands to strings and perform an actual concatenation.

`+` on the other hand can be an addition, or a concatenation, depending on the operand types.

## Noncompliant Code Example


    Module Module1
        Sub Main()
            Console.WriteLine("1" + 2) ' Noncompliant - will display "3"
        End Sub
    End Module


## Compliant Solution


    Module Module1
        Sub Main()
            Console.WriteLine(1 &amp; 2)   ' Compliant - will display "12"
            Console.WriteLine(1 + 2)   ' Compliant - but will display "3"
            Console.WriteLine("1" &amp; 2) ' Compliant - will display "12"
        End Sub
    End Module

