
Having two `Cases` in the same `Select` statement or branches in the same `If` structure with the same implementation is at best duplicate code, and at worst a coding error. If the same logic is truly needed for both instances, then in an `If` structure they should be combined, or for a `Select`, one should fall through to the other.

## Noncompliant Code Example


    Select i
      Case 1
        DoFirst()
        DoSomething()
      Case 2
        DoSomethingDifferent()
      Case 3  ' Noncompliant; duplicates case 1's implementation
        DoFirst()
        DoSomething()
      Case Else:
        DoTheRest()
    End Select
    
    If a &gt;= 0 AndAlso a &lt; 10 Then
      DoFirst()
      DoTheThing()
    ElseIf a &gt;= 10 AndAlso a &lt; 20 Then
      DoTheOtherThing()
    ElseIf a &gt;= 20 AndAlso a &lt; 50   ' Noncompliant; duplicates first condition
      DoFirst()
      DoTheThing()
    Else
      DoTheRest();
    End If


## Exceptions

Blocks in an `If` chain or `Case` clause that contain a single line of code are ignored.


    If a &gt;= 0 AndAlso a &lt; 10 Then
      DoTheThing()
    ElseIf a &gt;= 10 AndAlso a &lt; 20 Then
      DoTheOtherThing()
    ElseIf a &gt;= 20 AndAlso a &lt; 50   ' no issue, usually this is done on purpose to increase the readability
      DoTheThing()
    End If


But this exception does not apply to `If` chains without `Else`-s, or to `Select`-s without `Case Else` clauses when all branches have the same single line of code. In case of `If` chains with `Else`-s, or of `Select`-es with `Case Else` clauses, rule {rule:vbnet:S3923} raises a bug.


    If a &gt;= 0 AndAlso a &lt; 10 Then
      DoTheThing()
    ElseIf a &gt;= 10 AndAlso a &lt; 20 Then
      DoTheOtherThing()  ' Noncompliant, this might have been done on purpose but probably not
    End If

