
When the names of parameters in a procedure call match the names of the procedure arguments, it contributes to a clearer, more readable code. However, when the names match but are passed in a different order than the method arguments, it indicates a mistake in the parameter order which will likely lead to unexpected results.

## Noncompliant Code Example


    Public Function Divide(ByVal divisor As Integer, ByVal dividend As Integer) As Double
        Return divisor / dividend
    End Function
    
    Public Sub DoTheThing()
        Dim divisor = 15
        Dim dividend = 5
    
        Dim result = Divide(dividend, divisor)  ' Noncompliant; operation succeeds, but result is unexpected
        '...
    End Sub


## Compliant Solution


    Public Function Divide(ByVal divisor As Integer, ByVal dividend As Integer) As Double
        Return divisor / dividend
    End Function
    
    Public Sub DoTheThing()
        Dim divisor = 15
        Dim dividend = 5
    
        Dim result = Divide(divisor, dividend)
        '...
    End Sub

