
Consistent use of "None" in flags enumerations indicates that all flag values are cleared. The value 0 should not be used to indicate any other state, since there is no way to check that the bit `0` is set.

## Noncompliant Code Example


    &lt;Flags()&gt;
    Enum FruitType
        Void = 0        ' Non-Compliant
        Banana = 1
        Orange = 2
        Strawberry = 4
    End Enum


## Compliant Solution


    &lt;Flags()&gt;
    Enum FruitType
        None = 0        ' Compliant
        Banana = 1
        Orange = 2
        Strawberry = 4
    End Enum

