
Shared coding conventions allow teams to collaborate efficiently. This rule checks that all even handler names match a provided regular expression.

The default configuration is:

- Either in Pascal case, i.e. starting with an upper case letter, e.g. OnMyButtonClicked
- Or, a subject, in Pascal or camel case, followed by an underscore followed by an event name, in Pascal case, e.g. btn1\_Clicked


Event handlers with a `handles` clause and two-parameter methods with `EventArgs` second parameter are covered by this rule.

## Noncompliant Code Example

With the default regular expression `^(([a-z][a-z0-9]*)?([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?_)?([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`:


    Module Module1
        Sub subject__SomeEvent() Handles X.SomeEvent   ' Noncompliant - two underscores
        End Sub
    End Module


## Compliant Solution


    Module Module1
        Sub subject_SomeEvent() Handles X.SomeEvent    ' Compliant
        End Sub
    End Module

