
In most cases, indexed properties should be named Item for consistency. Exceptions are when there exists a name which is obviously better, for example `System.String.Chars(System.Int32)`.

## Noncompliant Code Example


    Module Module1
        Dim array = {"apple", "banana", "orange", "strawberry"}
    
        ReadOnly Property Foo(ByVal index As Integer)  ' Noncompliant
            Get
                Return array(index)
            End Get
        End Property
    End Module


## Compliant Solution


    Module Module1
        Dim array = {"apple", "banana", "orange", "strawberry"}
    
        ReadOnly Property Item(ByVal index As Integer)
            Get
                Return array(index)
            End Get
        End Property
    End Module


## Deprecated

This rule is deprecated, and will eventually be removed.
