
Fields should not be part of an API, and therefore should always be private. Indeed, they cannot be added to an interface for instance, and validation cannot be added later on without breaking backward compatibility. Instead, developers should encapsulate their fields into properties. Explicit property getters and setters can be introduced for validation purposes or to smooth the transition to a newer system.

## Noncompliant Code Example


    Class Foo
        Public Foo = 42          ' Noncompliant
    End Class


## Compliant Solution


    Class Foo
        Public Property Foo = 42 ' Compliant
    End Class


## Exceptions

`Shared` and `Const` fields are ignored.
