
Most developers expect property access to be as efficient as field access. However, if a property returns a copy of an array or collection, it will be much slower than a simple field access, contrary to the caller's likely expectations. Therefore, such properties should be refactored into methods so that callers are not surprised by unexpectedly poor performance.

## Noncompliant Code Example


    Module Module1
        ' Internal state
        Dim array = {"apple", "banana", "orange", "pineapple", "strawberry"}
    
        ReadOnly Property Foo() As String() ' Noncompliant
            Get
                Dim copy = array.Clone      ' Expensive call
                Return copy
            End Get
        End Property
    End Module


## Compliant Solution


    Module Module1
        ' Internal state
        Dim array = {"apple", "banana", "orange", "pineapple", "strawberry"}
    
        Function GetFoo() As String()       ' Compliant
            Dim copy = array.Clone
            Return copy
        End Function
    End Module

