
Exposing methods with multidimensional array parameters requires developers to have advanced knowledge about the language in order to be able to use them. Moreover, what exactly to pass to such parameters is not intuitive. Therefore, such methods should not be exposed, but can be used internally.

## Noncompliant Code Example


    Module Module1
        Sub WriteMatrix(ByVal matrix As Integer()()) ' Non-Compliant
            ' ...
        End Sub
    End Module


## Compliant Solution


    Class Matrix
        ' ...
    End Class
    
    Module Module1
        Sub WriteMatrix(ByVal matrix As Matrix)      ' Compliant
            ' ...
        End Sub
    End Module

