
Shared coding conventions allow teams to collaborate efficiently. This rule checks that all non-private fields names match a provided regular expression.

Note that this rule does not apply to non-private `Shared ReadOnly` fields, for which there is another rule.

The default configuration is:

- Pascal casing, starting with an upper case character, e.g. BackColor
- Short abbreviations of 2 letters can be capitalized, e.g. GetID
- Longer abbreviations need to be lower cased, e.g. GetHtml


## Noncompliant Code Example

With the default regular expression `^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`:


    Class Foo
        Public foo As Integer  ' Noncompliant
    End Class


## Compliant Solution


    Class Foo
        Public Foo As Integer  ' Compliant
    End Class

