
Property getters should be simple operations that are always safe to call. If exceptions need to be thrown, it is best to convert the property to a method.

It is valid to throw exceptions from indexed property getters and from property setters, which are not detected by this rule.

## Noncompliant Code Example


    Module Module1
        Public Property Foo() As Integer
            Get
                Throw New Exception  ' Non-Compliant
            End Get
            Set(ByVal value As Integer)
                ' ... some code ...
            End Set
        End Property
    End Module


## Compliant Solution


    Module Module1
        Sub SetFoo(ByVal value As Integer)         ' Compliant
            ' ... some code ...
        End Sub
    End Module


## Exceptions

No issue is raised when the thrown exception derives from or is of type `NotImplementedException`, `NotSupportedException` or `InvalidOperationException`.
