
Properties with only setters are confusing and counterintuitive. Instead, a property getter should be added if possible, or the property should be replaced with a setter method.

## Noncompliant Code Example


    Module Module1
        WriteOnly Property Foo() As Integer ' Non-Compliant
            Set(ByVal value As Integer)
                ' ... some code ...
            End Set
        End Property
    End Module


## Compliant Solution


    Module Module1
        Sub SetFoo(ByVal value As Integer)  ' Compliant
            ' ... some code ...
        End Sub
    End Module

