
Visual Basic .NET, unlike many other programming languages, has no "fall-through" for its `Select` cases. Each case already has an implicit `Exit Select` as its last instruction. It therefore is redundant to explicitly add one.

## Noncompliant Code Example


    Module Module1
      Sub Main()
        Dim x = 0
        Select Case x
          Case 0
            Console.WriteLine("0")
            Exit Select                ' Noncompliant
          Case Else
            Console.WriteLine("Not 0")
            Exit Select                ' Noncompliant
        End Select
      End Sub
    End Module


## Compliant Solution


    Module Module1
      Sub Main()
        Dim x = 0
        Select Case x
          Case 0                         ' Compliant
            Console.WriteLine("0")
          Case Else                      ' Compliant
            Console.WriteLine("Not 0")
        End Select
      End Sub
    End Module

