
Numbers can be shifted with the `<<` and `>>` operators, but the right operand of the operation needs to be an `int` or a type that has an implicit conversion to `int`. However, with `dynamic`, the compiler's type checking is turned off, so you can pass anything to a shift operator and have it compile. And if the argument can't be converted to `int` at runtime, then a `RuntimeBinderException` will be raised.

## Noncompliant Code Example


    Dim o As Object = 5
    Dim x As Integer = 5
    
    x = o &gt;&gt; 5 ' Noncompliant
    x = x &gt;&gt; o ' Noncompliant


## Exceptions

This rule does not raise when the left or the right expression is `Nothing`.


    x = Nothing &gt;&gt; 5
    x = 5 &gt;&gt; Nothing

