
A class with only `private` constructors can't be instantiated, thus, it seems to be pointless code.

## Noncompliant Code Example


    Public Class [MyClass]
        Private Sub New() // Noncompliant
            ' ...
        End Sub
    End Class


## Compliant Solution


    Public Class [MyClass]
        Private Sub New()
            ' ...
        End Sub
    End Class


## Exceptions

Classes that themselves access their private constructors (singletons or smart enums) are ignored. Classes with only `static` members are also ignored because they are covered by Rule S1118.
