
When declaring a Windows Communication Foundation (WCF) `OperationContract` method one-way, that service method won't return any result, not even an underlying empty confirmation message. These are fire-and-forget methods that are useful in event-like communication. Specifying a return type therefore does not make sense.

## Noncompliant Code Example


    &lt;ServiceContract&gt;
    Interface IMyService
        &lt;OperationContract(IsOneWay:=True)&gt;
        Function SomethingHappened(ByVal parameter As Integer) As Integer ' Noncompliant
    End Interface


## Compliant Solution


    &lt;ServiceContract&gt;
    Interface IMyService
        &lt;OperationContract(IsOneWay:=True)&gt;
        Sub SomethingHappened(ByVal parameter As Integer)
    End Interface


## Exceptions

The rule doesn't report if `OperationContractAttribute.AsyncPattern` is set to `true`.
