
It may be a good idea to raise an exception in a constructor if you're unable to fully flesh the object in question, but not in an `exception` constructor. If you do, you'll interfere with the exception that was originally being thrown. Further, it is highly unlikely that an exception raised in the creation of an exception will be properly handled in the calling code, and the unexpected, unhandled exception will lead to program termination.

## Noncompliant Code Example


    Class MyException
        Inherits Exception
    
        Public Sub MyException()
            If bad_thing Then
                Throw New Exception("A bad thing happened")
            End If
        End Sub
    End Class


## Deprecated

This rule is deprecated, and will eventually be removed.
