
Having all branches in a `Select Case` or `If` chain with the same implementation is an error. Either a copy-paste error was made and something different should be executed, or there shouldn't be a `Select Case` / `If` chain at all.

## Noncompliant Code Example


    Dim b As Integer = If(a &gt; 12, 4, 4)
    
    If b = 0 Then
        DoTheThing()
    Else
        DoTheThing()
    End If
    
    Select Case i
        Case 1
            DoSomething()
        Case 2
            DoSomething()
        Case 3
            DoSomething()
        Case Else
            DoSomething()
    End Select


## Exceptions

This rule does not apply to `If` chains without `Else`-s, or to `Select Case`-es without `Case Else` clauses.


    If b = 0 Then ' No issue, this could have been done on purpose to make the code more readable
        DoTheThing()
    ElseIf
        DoTheThing()
    End If

