
Fields marked with `System.Runtime.Serialization.OptionalFieldAttribute` are serialized just like any other field. But such fields are ignored on deserialization, and retain the default values associated with their types. Therefore, deserialization event handlers should be declared to set such fields during the deserialization process.

This rule raises when at least one field with the `System.Runtime.Serialization.OptionalFieldAttribute` attribute is declared but one (or both) of the following event handlers `System.Runtime.Serialization.OnDeserializingAttribute` or `System.Runtime.Serialization.OnDeserializedAttribute` are not present.

## Noncompliant Code Example


    &lt;Serializable&gt;
    Public Class Foo ' Noncompliant
        &lt;OptionalField(VersionAdded:=2)&gt;
        Private optionalField As Integer = 5
    End Class


## Compliant Solution


    &lt;Serializable&gt;
    Public Class Foo
        &lt;OptionalField(VersionAdded:=2)&gt;
        Private optionalField As Integer = 5
    
        &lt;OnDeserializing&gt;
        Private Sub OnDeserializing(ByVal context As StreamingContext)
            optionalField = 5
        End Sub
    
        &lt;OnDeserialized&gt;
        Private Sub OnDeserialized(ByVal context As StreamingContext)
        End Sub
    End Class

