
Serialization event handlers that don't have the correct signature will simply not be called, thus bypassing any attempts to augment the automated de/serialization.

This rule raises issue when a method marked with one of the following attributes is not `private`, does not return `void`, has type parameters, or does not have a single parameter of type `System.Runtime.Serialization.StreamingContext`:

- `System.Runtime.Serialization.OnSerializingAttribute`
- `System.Runtime.Serialization.OnSerializedAttribute`
- `System.Runtime.Serialization.OnDeserializingAttribute`
- `System.Runtime.Serialization.OnDeserializedAttribute`


## Noncompliant Code Example


    &lt;Serializable&gt;
    Public Class Foo
        &lt;OnSerializing&gt;
        Public Sub OnSerializing(ByVal context As StreamingContext) ' Noncompliant should be private
        End Sub
    
        &lt;OnSerialized&gt;
        Private Function OnSerialized(ByVal context As StreamingContext) As Integer '  Noncompliant should return void
        End Function
    
        &lt;OnDeserializing&gt;
        Private Sub OnDeserializing() ' Noncompliant should have a single parameter of type StreamingContext
        End Sub
    
        &lt;OnSerializing&gt;
        Public Sub OnSerializing2(Of T)(ByVal context As StreamingContext) ' Noncompliant should have no type parameters
        End Sub
    
        &lt;OnDeserialized&gt;
        Private Sub OnDeserialized(ByVal context As StreamingContext, ByVal str As String) ' Noncompliant should have a single parameter of type StreamingContext
        End Sub
    End Class


## Compliant Solution


    &lt;Serializable&gt;
    Public Class Foo
        &lt;OnSerializing&gt;
        Private Sub OnSerializing(ByVal context As StreamingContext)
        End Sub
    
        &lt;OnSerialized&gt;
        Private Sub OnSerialized(ByVal context As StreamingContext)
        End Sub
    
        &lt;OnDeserializing&gt;
        Private Sub OnDeserializing(ByVal context As StreamingContext)
        End Sub
    
        &lt;OnDeserialized&gt;
        Private Sub OnDeserialized(ByVal context As StreamingContext)
        End Sub
    End Class

