
For clarity, all overloads of the same method should be grouped together. That lets both users and maintainers quickly understand all the current available options.

## Noncompliant Code Example


    Interface IMyInterface
        Function DoTheThing() As Integer
        Function DoTheOtherThing() As String // Noncompliant
        Function DoTheThing(ByVal Path As String) As Integer
    End Interface


## Compliant Solution


    Interface IMyInterface
        Function DoTheThing() As Integer
        Function DoTheThing(ByVal Path As String) As Integer
        Function DoTheOtherThing() As String
    End Interface

