
When two methods have the same implementation, either it was a mistake - something else was intended - or the duplication was intentional, but may be confusing to maintainers. In the latter case, one implementation should invoke the other.

## Noncompliant Code Example


    Private Const CODE As String = "bounteous"
    Private callCount As Integer = 0
    
    Public Function GetCode() As String
      callCount = callCount + 1
      Return CODE
    End Function
    
    Public Function GetName() As String ' Noncompliant
      callCount = callCount + 1
      Return CODE
    End Function


## Compliant Solution


    Private Const CODE As String = "bounteous"
    Private callCount As Integer = 0
    
    Public Function GetCode() As String
      callCount = callCount + 1
      Return CODE
    End Function
    
    Public Function GetName() As String
      Return GetCode()
    End Function


## Exceptions

Empty methods, methods with only one line of code and methods with the same name (overload) are ignored.
