
There's no need to null test in conjunction with an `TypeOf ... Is` test. `Nothing` is not an instance of anything, so a null check is redundant.

## Noncompliant Code Example


    If (x IsNot Nothing And TypeOf x Is MyClass)
        ' ...
    End If
    
    If (x Is Nothing Or TypeOf x IsNot MyClass)
        ' ...
    End If


## Compliant Solution


    If (TypeOf x Is MyClass)
        ' ...
    End If
    
    If (TypeOf x IsNot MyClass)
        ' ...
    End If

