
When an assembly uses Windows Forms (classes and interfaces from the `System.Windows.Forms` namespace) its entry point should be marked with the `STAThreadAttribute` to indicate that the threading model should be "Single-Threaded Apartment" (STA) which is the only one supported by Windows Forms.

This rule raises an issue when the entry point (`Shared Sub Main` method) of an assembly using Windows Forms is not marked as STA.

## Noncompliant Code Example


    Imports System.Windows.Forms
    
    Public Class Foo
      Shared Sub Main()
        Dim winForm As Form = New Form
        Application.Run(winForm)
      End Sub
    End Class


## Compliant Solution


    Imports System.Windows.Forms
    
    Public Class Foo
      &lt;STAThread()&gt; Shared Sub Main()
        Dim winForm As Form = New Form
        Application.Run(winForm)
      End Sub
    End Class

