
The `PartCreationPolicyAttribute` attribute, which is part of the Managed Extensibility Framework (MEF), is used to specify how the exported object will be created. Therefore it doesn't make sense not to export this a class with this attribute using the `ExportAttribute` attribute.

This rule raises an issue when a class is marked as shared with a `PartCreationPolicyAttribute` but lacks a `ExportAttribute`.

## Noncompliant Code Example


    &lt;PartCreationPolicy(CreationPolicy.Any)&gt; ' Noncompliant
    Public Class FooBar
        Inherits IFooBar
    End Class


## Compliant Solution


    &lt;Export(GetType(IFooBar))&gt;
    &lt;PartCreationPolicy(CreationPolicy.Any)&gt;
    Public Class FooBar
        Inherits IFooBar
    End Class

