
Returning `Nothing` from a non-`async` `Task`/`Task(Of T)` method will cause a `NullReferenceException` at runtime. This problem can be avoided by returning `Task.FromResult(Of T)(Nothing)` instead.

## Noncompliant Code Example


    Public Function GetFooAsync() As Task(Of Object)
        Return Nothing
    End Function


## Compliant Solution


    Public Function GetFooAsync() As Task(Of Object)
        Return Task.FromResult(Of Object)(Nothing)
    End Function

