
Using sockets is security-sensitive. It has led in the past to the following vulnerabilities:

- [CVE-2011-178](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2011-1785)
- [CVE-2017-5645](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-5645)
- [CVE-2018-6597](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-6597)


Sockets are vulnerable in multiple ways:

- They enable a software to interact with the outside world. As this world is full of attackers it is necessary to check that they cannot receive<br>  sensitive information or inject dangerous input.
- The number of sockets is limited and can be exhausted. Which makes the application unresponsive to users who need additional sockets.


This rules flags code that creates sockets. It matches only the direct use of sockets, not use through frameworks or high-level APIs such as the use of http connections.

## Ask Yourself Whether

- sockets are created without any limit every time a user performs an action.
- input received from sockets is used without being sanitized.
- sensitive data is sent via sockets without being encrypted.


You are at risk if you answered yes to any of these questions.

## Recommended Secure Coding Practices

- In many cases there is no need to open a socket yourself. Use instead libraries and existing protocols.
- Encrypt all data sent if it is sensitive. Usually it is better to encrypt it even if the data is not sensitive as it might change later.
- [Sanitize](https://www.owasp.org/index.php/Input_Validation_Cheat_Sheet) any input read from the socket.
- Limit the number of sockets a given user can create. Close the sockets as soon as possible.


## Sensitive Code Example


    Imports System.Net.Sockets
    
    Public Class Sockets
    
        Public Shared Sub Run()
            ' Sensitive
            Dim socket As Socket = New Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp)
    
            ' TcpClient And UdpClient simply abstract the details of creating a Socket
            Dim client As TcpClient = New TcpClient("example.com", 80) ' Sensitive
            Dim listener As UdpClient = New UdpClient(80)   ' Sensitive
        End Sub
    
    End Class


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [MITRE, CWE-20](http://cwe.mitre.org/data/definitions/20) - Improper Input Validation
- [MITRE, CWE-400](http://cwe.mitre.org/data/definitions/400) - Uncontrolled Resource Consumption ('Resource Exhaustion')
- [MITRE, CWE-200](http://cwe.mitre.org/data/definitions/200) - Information Exposure
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat2) - Risky Resource Management
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses

