
Expanding archive files is security-sensitive. For example, expanding archive files has led in the past to the following vulnerabilities:

- [CVE-2018-1263](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-1263)
- [CVE-2018-16131](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-16131)


Applications that expand archive files (zip, tar, jar, war, 7z, ...) should verify the path where the archive's files are expanded and not trust blindly the content of the archive. Archive's files should not be expanded outside of the root directory where the archive is supposed to be expanded. Also, applications should control the size of the expanded data to not be a victim of Zip Bomb attack. Failure to do so could allow an attacker to use a specially crafted archive that holds directory traversal paths (e.g. ../../attacker.sh) or the attacker could overload the file system, processors or memory of the operating system where the archive is expanded making the target OS completely unusable.

This rule raises an issue when code handle archives. The goal is to guide security code reviews.

## Ask Yourself Whether

- there is no validation of the name of the archive entry
- there is no validation of the effective path where the archive entry is going to be expanded
- there is no validation of the size of the expanded archive entry
- there is no validation of the ratio between the compressed and uncompressed archive entry


You are at risk if you answered yes to any of those questions.



## Recommended Secure Coding Practices

Validate the full path of the extracted file against the full path of the directory where files are expanded.

- the canonical path of the expanded file must start with the canonical path of the directory where files are extracted.
- the name of the archive entry must not contain "..", i.e. reference to a parent directory.


Stop extracting the archive if any of its entries has been tainted with a directory traversal path.

Define and control the ratio between compressed and uncompress bytes.

Define and control the maximum allowed expanded file size.

Count the number of file entries extracted from the archive and abort the extraction if their number is greater than a predefined threshold.

## Sensitive Code Example


    For Each entry As ZipArchiveEntry in archive.Entries
        ' entry.FullName could contain parent directory references ".." and the destinationPath variable could become outside of the desired path
        string destinationPath = Path.GetFullPath(Path.Combine(path, entry.FullName))
        entry.ExtractToFile(destinationPath) ' Sensitive, extracts the entry to a file
    
        Dim stream As Stream
        stream = entry.Open() ' Sensitive, the entry is about to be extracted
    Next


## See

- [OWASP Top 10 2017 Category A5](https://www.owasp.org/index.php/Top_10-2017_A5-Broken_Access_Control) - Broken Access Control
- [MITRE, CWE-409](http://cwe.mitre.org/data/definitions/409.html) - Improper Handling of Highly Compressed Data (Data Amplification)<br>
- [CERT, IDS04-J.](https://wiki.sei.cmu.edu/confluence/display/java/IDS04-J.+Safely+extract+files+from+ZipInputStream) - Safely<br>  extract files from ZipInputStream
- Snyk Research Team: [Zip Slip Vulnerability](https://snyk.io/research/zip-slip-vulnerability)

