# [Class defines hashCode() and uses Object.equals()](https://spotbugs.readthedocs.io/en/latest/bugDescriptions.html#HE_HASHCODE_USE_OBJECT_EQUALS)

 This class defines a `hashCode()` method but inherits its
  `equals()` method from `java.lang.Object`
  (which defines equality by comparing object references).  Although
  this will probably satisfy the contract that equal objects must have
  equal hashcodes, it is probably not what was intended by overriding
  the `hashCode()` method.  (Overriding `hashCode()`
  implies that the object's identity is based on criteria more complicated
  than simple reference equality.)

If you don't think instances of this class will ever be inserted into a HashMap/HashTable,
the recommended `hashCode` implementation to use is:

    public int hashCode() {
        assert false : "hashCode not designed";
        return 42; // any arbitrary constant will do
    }