Enforces whitespace style conventions.

Helps maintain a readable, consistent style in your codebase.


Several arguments may be optionally provided:

* `"check-branch"` checks branching statements (`if`/`else`/`for`/`while`) are followed by whitespace.
* `"check-decl"`checks that variable declarations have whitespace around the equals token.
* `"check-operator"` checks for whitespace around operator tokens.
* `"check-module"` checks for whitespace in import & export statements.
* `"check-separator"` checks for whitespace after separator tokens (`,`/`;`).
* `"check-rest-spread"` checks that there is no whitespace after rest/spread operator (`...`).
* `"check-type"` checks for whitespace before a variable type specification.
* `"check-typecast"` checks for whitespace between a typecast and its target.
* `"check-type-operator"` checks for whitespace between type operators `|` and `&`.
* `"check-preblock"` checks for whitespace before the opening brace of a block.
* `"check-postbrace"` checks for whitespace after an opening brace.