**B603: Test for use of subprocess with shell equals true**

Python possesses many mechanisms to invoke an external executable.
However, doing so may present a security issue if appropriate care is
not taken to sanitize any user provided or variable input.

This plugin test is part of a family of tests built to check for process
spawning and warn appropriately. Specifically, this test looks for the
spawning of a subprocess without the use of a command shell. This type
of subprocess invocation is not vulnerable to shell injection attacks,
but care should still be taken to ensure validity of input.

Because this is a lesser issue than that described in
subprocess\_popen\_with\_shell\_equals\_true a LOW severity warning is
reported.

See also:

  - ../plugins/linux\_commands\_wildcard\_injection

  - ../plugins/subprocess\_popen\_with\_shell\_equals\_true

  - ../plugins/start\_process\_with\_no\_shell

  - ../plugins/start\_process\_with\_a\_shell

  - ../plugins/start\_process\_with\_partial\_path

**Config Options:**

This plugin test shares a configuration with others in the same family,
namely shell\_injection. This configuration is divided up into three
sections, subprocess, shell and no\_shell. They each list Python calls
that spawn subprocesses, invoke commands within a shell, or invoke
commands without a shell (by replacing the calling process)
respectively.

This plugin specifically scans for methods listed in subprocess section
that have shell=False specified.

    shell_injection:
        # Start a process using the subprocess module, or one of its
        wrappers.
        subprocess:
            - subprocess.Popen
            - subprocess.call

  - Example  

<!-- end list -->

    >> Issue: subprocess call - check for execution of untrusted input.
       Severity: Low   Confidence: High
       Location: ./examples/subprocess_shell.py:23
    22
    23    subprocess.check_output(['/bin/ls', '-l'])
    24

See
    also

  - <https://security.openstack.org>

  - <https://docs.python.org/2/library/subprocess.html#frequently-used-arguments>
    \#
    noqa

  - <https://security.openstack.org/guidelines/dg_avoid-shell-true.html>

  - <https://security.openstack.org/guidelines/dg_use-subprocess-securely.html>

New in version 0.9.0.

