**B605: Test for starting a process with a shell**

Python possesses many mechanisms to invoke an external executable.
However, doing so may present a security issue if appropriate care is
not taken to sanitize any user provided or variable input.

This plugin test is part of a family of tests built to check for process
spawning and warn appropriately. Specifically, this test looks for the
spawning of a subprocess using a command shell. This type of subprocess
invocation is dangerous as it is vulnerable to various shell injection
attacks. Great care should be taken to sanitize all input in order to
mitigate this risk. Calls of this type are identified by the use of
certain commands which are known to use shells. Bandit will report a LOW
severity warning.

See also:

  - ../plugins/linux\_commands\_wildcard\_injection

  - ../plugins/subprocess\_without\_shell\_equals\_true

  - ../plugins/start\_process\_with\_no\_shell

  - ../plugins/start\_process\_with\_partial\_path

  - ../plugins/subprocess\_popen\_with\_shell\_equals\_true

**Config Options:**

This plugin test shares a configuration with others in the same family,
namely shell\_injection. This configuration is divided up into three
sections, subprocess, shell and no\_shell. They each list Python calls
that spawn subprocesses, invoke commands within a shell, or invoke
commands without a shell (by replacing the calling process)
respectively.

This plugin specifically scans for methods listed in shell section.

    shell_injection:
        shell:
            - os.system
            - os.popen
            - os.popen2
            - os.popen3
            - os.popen4
            - popen2.popen2
            - popen2.popen3
            - popen2.popen4
            - popen2.Popen3
            - popen2.Popen4
            - commands.getoutput
            - commands.getstatusoutput

  - Example  

<!-- end list -->

    >> Issue: Starting a process with a shell: check for injection.
       Severity: Low   Confidence: Medium
       Location: examples/os_system.py:3
    2
    3   os.system('/bin/echo hi')

See
    also

  - <https://security.openstack.org>

  - <https://docs.python.org/2/library/os.html#os.system>

  - <https://docs.python.org/2/library/subprocess.html#frequently-used-arguments>
    \#
    noqa

  - <https://security.openstack.org/guidelines/dg_use-subprocess-securely.html>

New in version 0.10.0.

