## B609: Test for use of wildcard injection

Python provides a number of methods that emulate the behavior of
standard Linux command line utilities. Like their Linux counterparts,
these commands may take a wildcard “\*” character in place of a file
system path. This is interpreted to mean “any and all files or folders”
and can be used to build partially qualified paths, such as
“/home/user/\*”.

The use of partially qualified paths may result in unintended
consequences if an unexpected file or symlink is placed into the path
location given. This becomes particularly dangerous when combined with
commands used to manipulate file permissions or copy data off of a
system.

This test plugin looks for usage of the following commands in
conjunction with wild card parameters:

As well as any method configured in the shell or subprocess injection
test configurations.

**Config Options:**

This plugin test shares a configuration with others in the same family,
namely shell\_injection. This configuration is divided up into three
sections, subprocess, shell and no\_shell. They each list Python calls
that spawn subprocesses, invoke commands within a shell, or invoke
commands without a shell (by replacing the calling process)
respectively.

This test will scan parameters of all methods in all sections. Note that
methods are fully qualified and de-aliased prior to checking.

