## B701: Test for not auto escaping in jinja2

Jinja2 is a Python HTML templating system. It is typically used to build
web applications, though appears in other places well, notably the
Ansible automation system. When configuring the Jinja2 environment, the
option to use autoescaping on input can be specified. When autoescaping
is enabled, Jinja2 will filter input strings to escape any HTML content
submitted via template variables. Without escaping HTML input the
application becomes vulnerable to Cross Site Scripting (XSS) attacks.

Unfortunately, autoescaping is False by default. Thus this plugin test
will warn on omission of an autoescape setting, as well as an explicit
setting of false. A HIGH severity warning is generated in either of
these scenarios.

