## Delete the apt-get lists after installing something.

### Problematic code:

```dockerfile
RUN apt-get update && apt-get install -y python
```

### Correct code:

```dockerfile
RUN apt-get update && apt-get install -y python \
 && apt-get clean \
 && rm -rf /var/lib/apt/lists/*
```

### Rationale:

https://docs.docker.com/engine/articles/dockerfile_best-practices/

> In addition, cleaning up the apt cache and removing /var/lib/apt/lists helps keep the image size down. Since the RUN statement starts with apt-get update, the package cache will always be refreshed prior to apt-get install.

### Notes:

Clean up must be performed in the same RUN step, otherwise it will not affect image size.