# Did you forget to close this double quoted string?

### Problematic code:

```sh
greeting="hello
target="world"
```

### Correct code:

```sh
greeting="hello"
target="world"
```

### Rationale:

The first line is missing a quote.

ShellCheck warns when it detects multi-line double quoted, single quoted or backticked strings when the character that follows it looks out of place (and gives a companion warning [[SC1079]] at that spot).

### Exceptions

If you do want a multiline variable, just make sure the character after it is a quote, space or line feed.

```sh
var='multiline
'value
```

can be rewritten for readability and to remove the warning:

```sh
var='multiline
value'
```

As always `` `..` `` should be rewritten to ``$(..)``.
