//#Patterns: Custom_Scala_InsecureCookie
import spray.http._
import org.joda.time.{DateTimeZone, DateTime}
import com.twitter.finagle.http._

class Test {

   def something = false

   //#Err: Custom_Scala_InsecureCookie
   HttpCookie("a", "b")
   //#Err: Custom_Scala_InsecureCookie
   HttpCookie(name="a", content="b")
   //#Err: Custom_Scala_InsecureCookie
   HttpCookie("a", content="b")
   //#Err: Custom_Scala_InsecureCookie
   HttpCookie("a", "b", maxAge=Option(1L), domain=Option("test"))
   //#Err: Custom_Scala_InsecureCookie
   HttpCookie("a", "b", secure = false)   
   //#Err: Custom_Scala_InsecureCookie
   HttpCookie("a", "b", Some(DateTime.now), Some(1), Some(""), Some(""), false, false)

   HttpCookie("a", "b", secure = true)
   HttpCookie("a", "b", Some(DateTime.now), secure = true)
   HttpCookie("a", "b", secure = something)
   HttpCookie("a", "b", Some(DateTime.now), Some(1), Some(""), Some(""), true, false)

   f match {
     case HttpCookie(aaa, bbbb, cccc, dddd, d, p, s, h, e) => true
     case _ => false
   }

   // Finagle
   //#Err: Custom_Scala_InsecureCookie
   val finagleInsecureCookie = new Cookie("test", "test")
   //#Err: Custom_Scala_InsecureCookie
   val finagleInsecureCookie1 = new Cookie("test", "test")
   finagleInsecureCookie1.isSecure = false

   val finagleSecureCookie = new Cookie("test", "test")
   finagleSecureCookie.isSecure = true
   val potentialSecureCookie = new Cookie("test", "Test")
   potentialSecureCookie.isSecure = something
}