## Semicolons directly after 'else' are not allowed. Just remove it.

### Problematic code:

```sh
if mycommand; then echo "True"; else; echo "False"; fi
```

### Correct code:

```sh
if mycommand; then echo "True"; else echo "False"; fi
```

### Rationale:

`else` keywords should not be followed by semicolons. It's not valid shell syntax.

You can follow them directly with a line break or another command.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1053)

