## Can't follow non-constant source. Use a directive to specify location.

### Problematic code:

```sh
. "$(find_install_dir)/lib.sh"
```

### Correct code:

```sh
# shellcheck source=src/lib.sh
. "$(find_install_dir)/lib.sh"
```

### Rationale:

ShellCheck is not able to include sourced files from paths that are determined at runtime. The file will not be read, potentially resulting in warnings about unassigned variables and similar.

Use a [[Directive]] to point shellcheck to a fixed location it can read instead.

### Exceptions:

If you don't care that ShellCheck is unable to account for the file, specify `# shellcheck source=/dev/null`.

#### shellcheck -P *SOURCEPATH*, --source-path=*SOURCEPATH*

`shellcheck -P dir1:dir2/libs`

Specify paths to search for sourced files, separated by `:` on Unix and `;` on Windows. Absolute paths will also be rooted in these. 

The special path ***`SCRIPTDIR`*** can be used to specify searching the currently checked script's directory, as in **`-P SCRIPTDIR`** or **`-P SCRIPTDIR/../libs`**. Subsequent `-P` flags accumulate and take precedence.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1090)

