## Use #!, not just #, for the shebang.

### Problematic code:

```sh
# /bin/bash
echo "Hello World"
```

### Correct code:

```sh
#! /bin/bash
echo "Hello World"
```
### Rationale:

You appear to be specifying a shebang, but missing the bang (i.e. `!`). The shebang should always be on the form `#!/path/shell`.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1113)

