## No comments allowed after here-doc token. Comment the next line instead.

### Problematic code:

```sh
cat << eof  # --- Start greeting --
Hello
eof         # --- End greeting ---
```

### Correct code:

```sh
cat << eof  # --- Start greeting --
Hello
eof
            # --- End greeting ---
```
### Rationale:

The terminator token for a here document must be on an entirely separate line. No comments are allowed on this line.

Place the comment somewhere else, such as on the following line.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1120)

