## Don't use ls | grep. Use a glob or a for loop with a condition to allow non-alphanumeric filenames.

### Problematic code:

```sh
ls /directory | grep mystring
```

or

```sh
rm $(ls | grep -v '\.c$')
```

### Correct code:

```sh
ls /directory/*mystring*
```

or

```sh
# BASH
shopt -s extglob
rm -- !(*.c)

# POSIX
for f in ./*
do
  case $f in
    *.c) true;;
    *) rm "$f";;
  esac
done
```

### Rationale:

[Parsing ls](https://mywiki.wooledge.org/ParsingLs) is generally a bad idea because the output is fragile and human readable. To better handle non-alphanumeric filenames, use a glob. If you need more advanced matching than a glob can provide, use a `for` loop.

### Exceptions:

- `ls` has sorting options that are tricky to get right with other commands. If a specific order of files is needed, ls _\<sort options\>_ | grep might be the best alternative.

### Related resources:

* [BashFaq: How can I find and safely handle file names containing newlines, spaces or both?](https://mywiki.wooledge.org/BashFAQ/020)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2010)

