## Use `find -print0` or `find -exec` to better handle non-alphanumeric filenames.

### Problematic code:

```sh
ls | xargs -n1 wc -w
```

### Correct code:

```sh
find . -maxdepth 1 -print0 | xargs -0 -n1 wc -w
```

```sh
find . -maxdepth 1 -exec wc -w {} \;
```

### Rationale:

Using `-print0` separates each output with a NUL character, rather than a newline, which is safer to pipe into `xargs`. Alternatively using `-exec` avoids the problem of piping and parsing filenames in the first place.

See [[SC2012]] for more details on this issue.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2011)

