## Use -print0/-0 or find -exec + to allow for non-alphanumeric filenames.

### Problematic code:

```sh
find . -type f | xargs md5sum
```

### Correct code:

```sh
find . -type f -print0 | xargs -0 md5sum
find . -type f -exec md5sum {} +
```

### Rationale:

By default, `xargs` interprets spaces and quotes in an unsafe and unexpected way. Whenever it's used, it should be used with `-0` or `--null` to split on `\0` bytes, and `find` should be made to output `\0` separated filenames.

POSIX does not require find or xargs to support null terminators, so you can also use `find -exec +`. 
### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2038)

