## This is interpreted as a shell file redirection, not a comparison.

### Problematic code:

```sh
[ 1 >2 ] || [ 3>'aaa bb' ] # Simple example of problematic code
```

### Correct code:

```sh
[ 1 -gt 2 ] || [ 3 \> 'aaa bb' ] # arithmetical, lexicographical
```
### Rationale:

A word that looks like a redirection in simple shell commands causes it to be interpreted as a redirection.
ShellCheck would guess that you don't want it in tests.

### Exceptions:

When it's among a continuous list of redirections at the end of a simple `test` command, it's more likely that
the user really meant to do a redirection. Or any other case that you mean to do that.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2065)

