## Numbers with leading 0 are considered octal.

### Problematic code:

```sh
echo $(( 16 - 08 ))
```

### Correct code:

```sh
echo $(( 16 - 8 ))
```
### Rationale:

ShellCheck found an integer literal with a leading zero, but containing the digits 8 or 9.

This is invalid, as the integer will be interpreted as an octal value (e.g. 0777 == 0x1FF == 511).

To have the value parsed in base 10, either remove the leading zeros as in the example, or specify the radix explicitly:

    echo $((10#08)) 

### Exceptions:

None

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!

[The BASH manual "Shell Arithmetic" chapter](https://www.gnu.org/software/bash/manual/html_node/Shell-Arithmetic.html)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2080)

