##  -e doesn't work with globs. Use a for loop.

### Problematic code:

```sh
if [ -e dir/*.mp3 ]
then
  echo "There are mp3 files."
fi
```

### Correct code:

```sh
for file in dir/*.mp3
do
  if [ -e "$file" ]
  then
    echo "There are mp3 files"
    break
  fi
done
```

### Rationale:

`[ -e file* ]` only works if there's 0 or 1 matches. If there are multiple, it becomes `[ -e file1 file2 ]`, and the test fails.

`[[ -e file* ]]` doesn't work at all.

Instead, use a for loop to expand the glob and check each result individually.

### Exceptions

None.

### Related resources:

* [BashFaq: How can I check whether a directory is empty or not? How do I check for any *.mpg files, or count how many there are?](https://mywiki.wooledge.org/BashFAQ/004)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2144)

