##  Literal tilde in PATH works poorly across programs.

### Problematic code:

```sh
PATH="$PATH:~/bin"
```

### Correct code:

```sh
PATH="$PATH:$HOME/bin"
```

### Rationale:

Having literal `~` in PATH is a bad idea. Bash handles it, but nothing else does.

This means that even if you're always using Bash, you should avoid it because any invoked program that relies on PATH will effectively ignore those entries.

For example, `make` may say `foo: Command not found` even though `foo` works fine from the shell and Make and Bash both use the same PATH. You'll get similar messages from any non-bash scripts invoked, and `whereis` will come up empty.

Use `$HOME` or full path instead.

### Exceptions

If your directory name actually contains a literal tilde, you can ignore this message.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2147)

