## Found trailing ] outside test. Add missing [ or quote if intentional.

### Problematic code:

```sh
if foo -eq bar ]; then true; fi
```

or

```sh
tr -d ]
```

### Correct code:

```sh
if [ foo -eq bar ]; then true; fi
```

or

```sh
tr -d ']'
```

### Rationale:

ShellCheck found a non-test command that ends with `]` or `]]`.

If this was intended to be a test expression like in the first example, add the missing `[` or `[[`. 

If the `]` was intended to be literal, like in `tr -d ]`, you can quote to make this obvious.

### Exceptions:

`tr -d ]` is valid and not different from `tr -d ']'`, so in these cases you can ignore the error instead.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2171)

